// $Id: CClosestNotePanel.cpp,v 1.4 2007/02/11 02:20:27 paul Exp $

/*
 * All contents of this source code are copyright 2007 Exp Digital Uk.
 * This file forms part of the example projects for the Infinity API.
 * You may not redistribute either the source code or the compiled binary.
 * The Infinity API is covered by a fair use licence which you should have recieved with this
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 */

#include "CClosestNotePanel.hpp"
#include "CSCalWindow.hpp"
using Exponent::SCal::CSCalWindow;
using Exponent::SCal::CClosestNotePanel;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CClosestNotePanel, CControlPanel);

//	===========================================================================
CClosestNotePanel::CClosestNotePanel(IControlRoot *root, const long uniqueId, const CRect &area)
				 : CControlPanel(root->getParentWindow(), root, uniqueId, area, NULL)
				 , m_closestNoteFreqEditBox(NULL)
				 , m_closestNoteOutputValueLabel(NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CClosestNotePanel);

	this->onDrawDrawThePanelBounds(false);

	const long top    = 9;
	const long width  = 74;
	const long height = 20;

	CRect freqArea = CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT;
	freqArea.setLeft(189);

	// BPM edit
	m_closestNoteFreqEditBox	  = new CTextEdit(this,  CControl::CCONTROL_NO_ID_REQUIRED, freqArea, "440.00", this);
	m_closestNoteOutputValueLabel = new CTextLabel(this, CControl::CCONTROL_NO_ID_REQUIRED, CSCalWindow::CSCALWINDOW_OUTPUTBOX_RECT, CString::CSTRING_EMPTY_STRING);

	// Reference
	m_closestNoteFreqEditBox->referenced();
	m_closestNoteOutputValueLabel->referenced();

	// Set the format
	m_closestNoteFreqEditBox->setTextFormat(CGraphics::e_centerCenterAlign);
	m_closestNoteOutputValueLabel->setTextFormat(CGraphics::e_centerCenterAlign);

	m_closestNoteFreqEditBox->setAlignment(CTextEdit::e_center);

	// Make single click editable
	m_closestNoteFreqEditBox->setSingleClickEditable();

	// Colours
	m_closestNoteFreqEditBox->setColours(		CAlphaColour::CALPHACOLOUR_BLACK, CSCalWindow::CSCALWINDOW_BACKGROUND_COLOUR, CSCalWindow::CSCALWINDOW_TEXT_COLOUR);
	m_closestNoteOutputValueLabel->setColours(	CAlphaColour::CALPHACOLOUR_BLACK, CAlphaColour::CALPHACOLOUR_WHITE, CSCalWindow::CSCALWINDOW_ANSWER_TEXT_COLOUR);

	// Add controls
	this->addControl(m_closestNoteFreqEditBox);
	this->addControl(m_closestNoteOutputValueLabel);

	// Compute
	this->computeClosestNote();
}

//	===========================================================================
CClosestNotePanel::~CClosestNotePanel()
{
	EXPONENT_CLASS_DESTRUCTION(CClosestNotePanel);
	FORGET_COUNTED_OBJECT(m_closestNoteFreqEditBox);
	FORGET_COUNTED_OBJECT(m_closestNoteOutputValueLabel);
}

//	===========================================================================
void CClosestNotePanel::handleActionEvent(const CActionEvent &event)
{
	this->computeClosestNote();
}

//	===========================================================================
void CClosestNotePanel::computeClosestNote()
{
	double frequency = CString::toDouble(m_closestNoteFreqEditBox->getString().getString());

	if (frequency <= 0.0 || frequency > 13000)
	{
		CDialog::notifyUser("Frequency range error!\n\n0.0 < bpm < 13000.0\n\nBpm must be between 0 and 13000 Hz", "SCal error", true);
		frequency = 440.0;
		m_closestNoteFreqEditBox->setText("440.00");
	}
	else
	{
		CString string;
		string.setStringWithFormat("%0.02f", frequency);
		m_closestNoteFreqEditBox->setText(string);
	}
	m_closestNoteFreqEditBox->update();

	CString output;
	CMidi::getMidiNoteString(CMusicMath::getClosestMidiNote(frequency), output);
	m_closestNoteOutputValueLabel->setText(output);
	m_closestNoteOutputValueLabel->update();
}